package FlashReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;


public class Unprotect {
	
	private int stos = -1;
	public  ByteBuffer bbuf;
	ByteBuffer bb;
	//pozycja|opcode|skok|size
	ArrayList<ArrayList<Integer>> kod ;
	
	//pozcyja|pozycja w kod
	HashMap<Integer,Integer> mapowanie ;
	
	
	
	public byte[] unprotect1(byte code[]){
		bbuf = ByteBuffer.allocate(code.length);
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.put(code);
		
		czytajKod(bbuf);
		
		bb  = ByteBuffer.allocate(bbuf.capacity());
		bb.order(ByteOrder.LITTLE_ENDIAN);
		bb.position(0);
		
		unp();
		
		czytajKod(bb);

		unp2();
		bb.position(0);
		
		
		return bb.array();
	}
	

	
	private String[] opNames = {
     	    "OP_0x00       ",
     	    "bkpt          ",
     	    "nop           ",
     	    "throw         ",
     	    "getsuper      ",
     	    "setsuper      ",
     	    "dxns          ",
     	    "dxnslate      ",
     	    "kill          ",
     	    "label         ",
     	    "OP_0x0A       ",
     	    "OP_0x0B       ",
     	    "ifnlt         ",
     	    "ifnle         ",
     	    "ifngt         ",
     	    "ifnge         ",
     	    "jump          ",
     	    "iftrue        ",
     	    "iffalse       ",
     	    "ifeq          ",
     	    "ifne          ",
     	    "iflt          ",
     	    "ifle          ",
     	    "ifgt          ",
     	    "ifge          ",
     	    "ifstricteq    ",
     	    "ifstrictne    ",
     	    "lookupswitch  ",
     	    "pushwith      ",
     	    "popscope      ",
     	    "nextname      ",
     	    "hasnext       ",
     	    "pushnull      ",
     	    "pushundefined ",
     	    "pushconstant  ",
     	    "nextvalue     ",
     	    "pushbyte      ",
     	    "pushshort     ",
     	    "pushtrue      ",
     	    "pushfalse     ",
     	    "pushnan       ",
     	    "pop           ",
     	    "dup           ",
     	    "swap          ",
     	    "pushstring    ",
     	    "pushint       ",
     	    "pushuint      ",
     	    "pushdouble    ",
     	    "pushscope     ",
     	    "pushnamespace ",
     	    "hasnext2      ",
     	    "OP_0x33       ",
     	    "OP_0x34       ",
     	    "OP_0x35       ",
     	    "OP_0x36       ",
     	    "OP_0x37       ",
     	    "OP_0x38       ",
     	    "OP_0x39       ",
     	    "OP_0x3A       ",
     	    "OP_0x3B       ",
     	    "OP_0x3C       ",
     	    "OP_0x3D       ",
     	    "OP_0x3E       ",
     	    "OP_0x3F       ",
     	    "newfunction   ",
     	    "call          ",
     	    "construct     ",
     	    "callmethod    ",
     	    "callstatic    ",
     	    "callsuper     ",
     	    "callproperty  ",
     	    "returnvoid    ",
     	    "returnvalue   ",
     	    "constructsuper",
     	    "constructprop ",
     	    "callsuperid   ",
     	    "callproplex   ",
     	    "callinterface ",
     	    "callsupervoid ",
     	    "callpropvoid  ",
     	    "OP_0x50       ",
     	    "OP_0x51       ",
     	    "OP_0x52       ",
     	    "OP_0x53       ",
     	    "OP_0x54       ",
     	    "newobject     ",
     	    "newarray      ",
     	    "newactivation ",
     	    "newclass      ",
     	    "getdescendants",
     	    "newcatch      ",
     	    "OP_0x5B       ",
     	    "OP_0x5C       ",
     	    "findpropstrict",
     	    "findproperty  ",
     	    "finddef       ",
     	    "getlex        ",
     	    "setproperty   ",
     	    "getlocal      ",
     	    "setlocal      ",
     	    "getglobalscope",
     	    "getscopeobject",
     	    "getproperty   ",
     	    "OP_0x67       ",
     	    "initproperty  ",
     	    "OP_0x69       ",
     	    "deleteproperty",
     	    "OP_0x6A       ",
     	    "getslot       ",
     	    "setslot       ",
     	    "getglobalslot ",
     	    "setglobalslot ",
     	    "convert_s     ",
     	    "esc_xelem     ",
     	    "esc_xattr     ",
     	    "convert_i     ",
     	    "convert_u     ",
     	    "convert_d     ",
     	    "convert_b     ",
     	    "convert_o     ",
     	    "checkfilter   ",
     	    "OP_0x79       ",
     	    "OP_0x7A       ",
     	    "OP_0x7B       ",
     	    "OP_0x7C       ",
     	    "OP_0x7D       ",
     	    "OP_0x7E       ",
     	    "OP_0x7F       ",
     	    "coerce        ",
     	    "coerce_b      ",
     	    "coerce_a      ",
     	    "coerce_i      ",
     	    "coerce_d      ",
     	    "coerce_s      ",
     	    "astype        ",
     	    "astypelate    ",
     	    "coerce_u      ",
     	    "coerce_o      ",
     	    "OP_0x8A       ",
     	    "OP_0x8B       ",
     	    "OP_0x8C       ",
     	    "OP_0x8D       ",
     	    "OP_0x8E       ",
     	    "OP_0x8F       ",
     	    "negate        ",
     	    "increment     ",
     	    "inclocal      ",
     	    "decrement     ",
     	    "declocal      ",
     	    "typeof        ",
     	    "not           ",
     	    "bitnot        ",
     	    "OP_0x98       ",
     	    "OP_0x99       ",
     	    "concat        ",
     	    "add_d         ",
     	    "OP_0x9C       ",
     	    "OP_0x9D       ",
     	    "OP_0x9E       ",
     	    "OP_0x9F       ",
     	    "add           ",
     	    "subtract      ",
     	    "multiply      ",
     	    "divide        ",
     	    "modulo        ",
     	    "lshift        ",
     	    "rshift        ",
     	    "urshift       ",
     	    "bitand        ",
     	    "bitor         ",
     	    "bitxor        ",
     	    "equals        ",
     	    "strictequals  ",
     	    "lessthan      ",
     	    "lessequals    ",
     	    "greaterthan   ",
     	    "greaterequals ",
     	    "instanceof    ",
     	    "istype        ",
     	    "istypelate    ",
     	    "in            ",
     	    "OP_0xB5       ",
     	    "OP_0xB6       ",
     	    "OP_0xB7       ",
     	    "OP_0xB8       ",
     	    "OP_0xB9       ",
     	    "OP_0xBA       ",
     	    "OP_0xBB       ",
     	    "OP_0xBC       ",
     	    "OP_0xBD       ",
     	    "OP_0xBE       ",
     	    "OP_0xBF       ",
     	    "increment_i   ",
     	    "decrement_i   ",
     	    "inclocal_i    ",
     	    "declocal_i    ",
     	    "negate_i      ",
     	    "add_i         ",
     	    "subtract_i    ",
     	    "multiply_i    ",
     	    "OP_0xC8       ",
     	    "OP_0xC9       ",
     	    "OP_0xCA       ",
     	    "OP_0xCB       ",
     	    "OP_0xCC       ",
     	    "OP_0xCD       ",
     	    "OP_0xCE       ",
     	    "OP_0xCF       ",
     	    "getlocal0     ",
     	    "getlocal1     ",
     	    "getlocal2     ",
     	    "getlocal3     ",
     	    "setlocal0     ",
     	    "setlocal1     ",
     	    "setlocal2     ",
     	    "setlocal3     ",
     	    "OP_0xD8       ",
     	    "OP_0xD9       ",
     	    "OP_0xDA       ",
     	    "OP_0xDB       ",
     	    "OP_0xDC       ",
     	    "OP_0xDD       ",
     	    "OP_0xDE       ",
     	    "OP_0xDF       ",
     	    "OP_0xE0       ",
     	    "OP_0xE1       ",
     	    "OP_0xE2       ",
     	    "OP_0xE3       ",
     	    "OP_0xE4       ",
     	    "OP_0xE5       ",
     	    "OP_0xE6       ",
     	    "OP_0xE7       ",
     	    "OP_0xE8       ",
     	    "OP_0xE9       ",
     	    "OP_0xEA       ",
     	    "OP_0xEB       ",
     	    "OP_0xEC       ",
     	    "OP_0xED       ",
     	    "OP_0xEE       ",
     	    "debug         ",
     	    "debugline     ",
     	    "debugfile     ",
     	    "bkptline      ",
     	    "timestamp     ",
     	    "OP_0xF4       ",
     	    "verifypass    ",
     	    "alloc         ",
     	    "mark          ",
     	    "wb            ",
     	    "prologue      ",
     	    "sendenter     ",
     	    "doubletoatom  ",
     	    "sweep         ",
     	    "codegenop     ",
     	    "verifyop      ",
     	    "decode        "
};

	private final int OP_bkpt = 0x01;
	private final int OP_nop = 0x02;
	private final int OP_throw = 0x03;
	private final int OP_getsuper = 0x04;
	private final int OP_setsuper = 0x05;
	private int OP_dxns = 0x06;
	private final int OP_dxnslate = 0x07;
	private final int OP_kill = 0x08;
	private final int OP_label = 0x09;
	private final int OP_ifnlt = 0x0C;
	private final int OP_ifnle = 0x0D;
	private final int OP_ifngt = 0x0E;
	private final int OP_ifnge = 0x0F;
	private final int OP_jump = 0x10;
	private final int OP_iftrue = 0x11;
	private final int OP_iffalse = 0x12;
	private final int OP_ifeq = 0x13;
	private final int OP_ifne = 0x14;
	private final int OP_iflt = 0x15;
	private final int OP_ifle = 0x16;
	private final int OP_ifgt = 0x17;
	private final int OP_ifge = 0x18;
	private final int OP_ifstricteq = 0x19;
	private final int OP_ifstrictne = 0x1A;
	private final int OP_lookupswitch = 0x1B;
	private final int OP_pushwith = 0x1C;
	private final int OP_popscope = 0x1D;
	private final int OP_nextname = 0x1E;
	private final int OP_hasnext = 0x1F;
	private final int OP_pushnull = 0x20;
	private final int OP_pushundefined = 0x21;
	private final int OP_pushconstant = 0x22;
	private final int OP_nextvalue = 0x23;
	private final int OP_pushbyte = 0x24;
	private final int OP_pushshort = 0x25;
	private final int OP_pushtrue = 0x26;
	private final int OP_pushfalse = 0x27;
	private final int OP_pushnan = 0x28;
	private final int OP_pop = 0x29;
	private final int OP_dup = 0x2A;
	private final int OP_swap = 0x2B;
	private final int OP_pushstring = 0x2C;
	private final int OP_pushint = 0x2D;
	private final int OP_pushuint = 0x2E;
	private final int OP_pushdouble = 0x2F;
	private final int OP_pushscope = 0x30;
	private final int OP_pushnamespace = 0x31;
	private final int OP_hasnext2 = 0x32;
	private final int OP_newfunction = 0x40;
	private final int OP_call = 0x41;
	private final int OP_construct = 0x42;
	private final int OP_callmethod = 0x43;
	private final int OP_callstatic = 0x44;
	private final int OP_callsuper = 0x45;
	private final int OP_callproperty = 0x46;
	private final int OP_returnvoid = 0x47;
	private final int OP_returnvalue = 0x48;
	private final int OP_constructsuper = 0x49;
	private final int OP_constructprop = 0x4A;
	private final int OP_callsuperid = 0x4B;
	private final int OP_callproplex = 0x4C;
	private final int OP_callinterface = 0x4D;
	private final int OP_callsupervoid = 0x4E;
	private final int OP_callpropvoid = 0x4F;
	private final int OP_newobject = 0x55;
	private final int OP_newarray = 0x56;
	private final int OP_newactivation = 0x57;
	private final int OP_newclass = 0x58;
	private final int OP_getdescendants = 0x59;
	private final int OP_newcatch = 0x5A;
	private final int OP_findpropstrict = 0x5D;
	private final int OP_findproperty = 0x5E;
	private final int OP_finddef = 0x5F;
	private final int OP_getlex = 0x60;
	private final int OP_setproperty = 0x61;
	private final int OP_getlocal = 0x62;
	private final int OP_setlocal = 0x63;
	private final int OP_getglobalscope = 0x64;
	private final int OP_getscopeobject = 0x65;
	private final int OP_getproperty = 0x66;
	private final int OP_getpropertylate = 0x67;
	private final int OP_initproperty = 0x68;
	private final int OP_setpropertylate = 0x69;
	private final int OP_deleteproperty = 0x6A;
	private final int OP_deletepropertylate = 0x6B;
	private final int OP_getslot = 0x6C;
	private final int OP_setslot = 0x6D;
	private final int OP_getglobalslot = 0x6E;
	private final int OP_setglobalslot = 0x6F;
	private final int OP_convert_s = 0x70;
	private final int OP_esc_xelem = 0x71;
	private final int OP_esc_xattr = 0x72;
	private final int OP_convert_i = 0x73;
	private final int OP_convert_u = 0x74;
	private final int OP_convert_d = 0x75;
	private final int OP_convert_b = 0x76;
	private final int OP_convert_o = 0x77;
	private final int OP_coerce = 0x80;
	private final int OP_coerce_b = 0x81;
	private final int OP_coerce_a = 0x82;
	private final int OP_coerce_i = 0x83;
	private final int OP_coerce_d = 0x84;
	private final int OP_coerce_s = 0x85;
	private final int OP_astype = 0x86;
	private final int OP_astypelate = 0x87;
	private final int OP_coerce_u = 0x88;
	private final int OP_coerce_o = 0x89;
	private final int OP_negate = 0x90;
	private final int OP_increment = 0x91;
	private final int OP_inclocal = 0x92;
	private final int OP_decrement = 0x93;
	private final int OP_declocal = 0x94;
	private final int OP_typeof = 0x95;
	private final int OP_not = 0x96;
	private final int OP_bitnot = 0x97;
	private final int OP_concat = 0x9A;
	private final int OP_add_d = 0x9B;
	private final int OP_add = 0xA0;
	private final int OP_subtract = 0xA1;
	private final int OP_multiply = 0xA2;
	private final int OP_divide = 0xA3;
	private final int OP_modulo = 0xA4;
	private final int OP_lshift = 0xA5;
	private final int OP_rshift = 0xA6;
	private final int OP_urshift = 0xA7;
	private final int OP_bitand = 0xA8;
	private final int OP_bitor = 0xA9;
	private final int OP_bitxor = 0xAA;
	private final int OP_equals = 0xAB;
	private final int OP_strictequals = 0xAC;
	private final int OP_lessthan = 0xAD;
	private final int OP_lessequals = 0xAE;
	private final int OP_greaterthan = 0xAF;
	private final int OP_greaterequals = 0xB0;
	private final int OP_instanceof = 0xB1;
	private final int OP_istype = 0xB2;
	private final int OP_istypelate = 0xB3;
	private final int OP_in = 0xB4;
	private final int OP_increment_i = 0xC0;
	private final int OP_decrement_i = 0xC1;
	private final int OP_inclocal_i = 0xC2;
	private final int OP_declocal_i = 0xC3;
	private final int OP_negate_i = 0xC4;
	private final int OP_add_i = 0xC5;
	private final int OP_subtract_i = 0xC6;
	private final int OP_multiply_i = 0xC7;
	private final int OP_getlocal0 = 0xD0;
	private final int OP_getlocal1 = 0xD1;
	private final int OP_getlocal2 = 0xD2;
	private final int OP_getlocal3 = 0xD3;
	private final int OP_setlocal0 = 0xD4;
	private final int OP_setlocal1 = 0xD5;
	private final int OP_setlocal2 = 0xD6;
	private final int OP_setlocal3 = 0xD7;
	private final int OP_debug = 0xEF;
	private final int OP_debugline = 0xF0;
	private final int OP_debugfile = 0xF1;
	private final int OP_bkptline = 0xF2;
		
	
	
	public  void czytajPlik() throws Exception{
		File file = new File("c:\\plik");
		FileInputStream f =new FileInputStream(file);
		
		bbuf = ByteBuffer.allocate(f.available());
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		byte result[] = new byte[f.available()];
		f.read(result);
		bbuf.put(result);
		f.close();
	}

public ArrayList<Integer> jumps = new ArrayList<Integer>();	
	
public  void czytajKod(ByteBuffer bbuf){
	int j = 0;
	//pozycja|opcode|skok|size
	 kod = new ArrayList<ArrayList<Integer>>();
	
	//pozcyja|pozycja w kod
	mapowanie = new HashMap<Integer,Integer>();
	
		bbuf.position(0);
		while (bbuf.position()<bbuf.capacity()){
			ArrayList<Integer> tmp = new ArrayList<Integer>(4);
			
			tmp.add(bbuf.position());
			mapowanie.put(bbuf.position(), j);
			
			int opcode = unsignedByte(bbuf.get());
			tmp.add(opcode);
					

							
						switch(opcode)
						{
								
							case OP_debugfile:
							case OP_pushstring:
								unsigned32int(bbuf);
								break;
							case OP_pushnamespace:
								unsigned32int(bbuf);
								break;
							case OP_pushint:
								int i = unsigned32int(bbuf);
								break;
							case OP_pushuint:
								int u = unsigned32int(bbuf);
								break;
							case OP_pushdouble:
								unsigned32int(bbuf);                                
								break;
							case OP_getsuper: ;
							case OP_setsuper: ;
							case OP_getproperty: ;
							case OP_initproperty: ;
							case OP_setproperty: ;
							case OP_getlex: ;
							case OP_findpropstrict: ;
							case OP_findproperty:;
							case OP_finddef:;
							case OP_deleteproperty: ;
							case OP_istype: ;
							case OP_coerce: ;
							case OP_astype: ;
							case OP_getdescendants:
								unsigned32int(bbuf);
								
								break;
							case OP_constructprop:
							case OP_callproperty:
							case OP_callproplex:
							case OP_callsuper:
							case OP_callsupervoid:
							case OP_callpropvoid:
								unsigned32int(bbuf); 
								               
								 unsigned32int(bbuf);
								break;
							case OP_newfunction: {
								int method_id = unsigned32int(bbuf);

								break;
							}
							case OP_callstatic:
								unsigned32int(bbuf);
								unsigned32int(bbuf);
								break;
							case OP_newclass: 
								unsigned32int(bbuf);               
								break;
							case OP_lookupswitch:
								int pos = bbuf.position()-1;
								int target = pos + readS24(bbuf);
								int maxindex =unsigned32int(bbuf);
								//s += "default:" + labels.labelFor(target) // target + "("+(target-pos)+")"
								for (int i1=0; i1 <= maxindex; i1++) {
									target = pos + readS24(bbuf);
									//s += " " + labels.labelFor(target) // target + "("+(target-pos)+")"
								}
								break;
							case OP_jump:
							case OP_iftrue:		case OP_iffalse:
							case OP_ifeq:		case OP_ifne:
							case OP_ifge:		case OP_ifnge:
							case OP_ifgt:		case OP_ifngt:
							case OP_ifle:		case OP_ifnle:
							case OP_iflt:		case OP_ifnlt:
							case OP_ifstricteq:	case OP_ifstrictne:
								int offset = readS24(bbuf);
								int target1 = bbuf.position()+offset;
								//s += target + " ("+offset+")"
								jumps.add(target1);
								tmp.add(target1);
								//if (!((bbuf.position()) in labels))
								//	s += "\n"
								break;
							case OP_inclocal:
							case OP_declocal:
							case OP_inclocal_i:
							case OP_declocal_i:
							case OP_getlocal:
							case OP_kill:
							case OP_setlocal:
							case OP_debugline:
							case OP_getglobalslot:
							case OP_getslot:
							case OP_setglobalslot:
							case OP_setslot:
							case OP_pushshort:
							case OP_newcatch:
								unsigned32int(bbuf);
								break;
							case OP_debug:
								unsignedByte(bbuf.get());
								unsigned32int(bbuf);
								unsignedByte(bbuf.get());
								unsigned32int(bbuf);
								break;
							case OP_newobject:
								unsigned32int(bbuf);
								break;
							case OP_newarray:
								unsigned32int(bbuf);
								break;
							case OP_call:
							case OP_construct:
							case OP_constructsuper:
								unsigned32int(bbuf);
								break;
							case OP_pushbyte:
							case OP_getscopeobject:
								unsignedByte(bbuf.get());
								break;
							case OP_hasnext2:
								unsigned32int(bbuf);
								unsigned32int(bbuf);
							default:
								/*if (opNames[opcode] == ("0x"+opcode.toString(16).toUpperCase()))
									s += " UNKNOWN OPCODE"*/
								break;
						}
						if(tmp.size()==2)tmp.add(0);
						tmp.add(bbuf.position()-tmp.get(0));
						kod.add(tmp);
						j++;
		}
	
	}
	

public int unp(){
	int trfoPos = -1;
	int length =0;
	for (int i=0 ; i <kod.size();i++){
		ArrayList<Integer> tmp = kod.get(i);
		System.out.println(length);
		int poz = tmp.get(0);
		int op = tmp.get(1);
		int skok = tmp.get(2);
		int size = tmp.get(3);
		
		if (op ==OP_jump){
			if (checkJump(poz,skok)&& skok-poz>0){
				System.out.println("Skacze: OP_jump");
				bbuf.position(poz);
				for (int i2 =0; i2 < skok-poz;i2++){
					bb.put((byte) 0x02);
					length++;
				}
				i = mapowanie.get(skok)-1;
			}else{
				System.out.println("kopiujeJ");
				bbuf.position(poz);
				for (int i2 =0; i2 < size;i2++){
					bb.put(bbuf.get());
					length++;
				}
			}
		}else if (op ==OP_iftrue){
			if(checkJump(poz,skok) &&stos==1&& skok-poz>0) {
				bbuf.position(poz);
				System.out.println("Skacze: OP_iftrue");
				i = mapowanie.get(skok)-1;
				for (int i2 =0; i2 < skok-poz;i2++){
					bb.put((byte) 0x02);
					length++;
				}
				bb.put(trfoPos,(byte) 0x02);
				stos =-1;
			}else if (stos ==0){
				System.out.println("Pomijam: OP_iftrue");
				bbuf.position(poz);
				for (int i2 =0; i2 < size;i2++){
					bb.put((byte) 0x02);
					length++;
				}
				bb.put(trfoPos,(byte) 0x02);
				stos =-1;
			}else{
				
				ArrayList<Integer> tmp2 = kod.get(mapowanie.get(skok));
				int op2 = tmp2.get(1);
				
				if((op2==0x47||op2==0x48)&& stos==1){
					bbuf.position(poz);
					for (int i2 =0; i2 < size;i2++){
						bb.put((byte) 0x02);
						length++;
					}
					
					bb.put(trfoPos,(byte) 0x02);
					stos =-1;
					
				}else{
					System.out.println("kopiuje");
					bbuf.position(poz);
					for (int i2 =0; i2 < size;i2++){
						bb.put(bbuf.get());
						length++;
					}
				
					
				}
				
				
				
				
				
			}
			
		}else if (op ==OP_iffalse){
			if(checkJump(poz,skok) &&stos==0&& skok-poz>0) {
				bbuf.position(poz);
				System.out.println("Skacze: OP_iffalse");
				i = mapowanie.get(skok)-1;
				for (int i2 =0; i2 < skok-poz;i2++){
					bb.put((byte) 0x02);
					length++;
				}
				bb.put(trfoPos,(byte) 0x02);
				stos =-1;
			}else if (stos ==1){
				System.out.println("Pomijam: OP_iffalse");
				bbuf.position(poz);
				for (int i2 =0; i2 < size;i2++){
					bb.put((byte) 0x02);
					length++;
				}
				bb.put(trfoPos,(byte) 0x02);
				stos =-1;
			}else{
				
				ArrayList<Integer> tmp2 = kod.get(mapowanie.get(skok));
				int op2 = tmp2.get(1);
				
				if((op2==0x47||op2==0x48)&& stos==0){
					bbuf.position(poz);
					for (int i2 =0; i2 < size;i2++){
						bb.put((byte) 0x02);
						length++;
					}
					
					bb.put(trfoPos,(byte) 0x02);
					stos =-1;
					
					
				}else{
					System.out.println("kopiuje");
					bbuf.position(poz);
					for (int i2 =0; i2 < size;i2++){
						bb.put(bbuf.get());
						length++;
					}
				
					
				}

				
			}
			
		}else if((op ==OP_returnvalue||op ==OP_returnvoid)&& i <kod.size()-1){
			ArrayList<Integer> tmp2 = kod.get(i+1);
			int op2 = tmp2.get(1);
			int poz2 = tmp2.get(0);
			int size2 = tmp2.get(3);
			
			if (op2 ==OP_returnvalue||op2 ==OP_returnvoid){
				bbuf.position(poz2);
				bbuf.put((byte) 0x02);
				
			}
			
			bbuf.position(poz);
			for (int i2 =0; i2 < size;i2++){
					bb.put(bbuf.get());
					length++;
			}
			
				
			
		}else{
			if (op ==OP_pushfalse){
				stos =0;
				trfoPos= bb.position();
			}
			else if (op ==OP_pushtrue){
				stos = 1;
				trfoPos= bb.position();
			}
			System.out.println("kopiuje");
			bbuf.position(poz);

			for (int i2 =0; i2 < size;i2++){
				bb.put(bbuf.get());
				length++;
			}
			
			
		}
		
	}
	return length;
	
}

public void unp2(){
	
	for (int i=0 ; i <kod.size();i++){
		
		ArrayList<Integer> tmp = kod.get(i);
		int poz = tmp.get(0);
		int op = tmp.get(1);
		int skok = tmp.get(2);
		int size = tmp.get(3);
		
		if (op ==OP_jump){
			System.out.println("mam");
			ArrayList<Integer> tmp2 = kod.get((mapowanie.get(skok)));
			
			
			
			int poz2 = tmp2.get(0);
			int op2 = tmp2.get(1);
			int skok2 = tmp2.get(2);
			int size2 = tmp2.get(3);
			
		
			
			
			if(op2==OP_jump){
				
				System.out.println("op1 " + op);
				System.out.println("op2 "+ op2);
				
				
				
				System.out.println("skok: "+skok);
				System.out.println("tmp2: "+tmp2);
				System.out.println("tmp: "+tmp);
				
				//System.out.println("Rzucam: " + skok2 + " - " +poz);
				bb.position(poz2);
				for(int k=0; k < size2;k++){
					bb.put((byte)0x02);
				}
				int offset =0;
				
				if(skok2>poz){
					offset = skok2-(poz+4);
				}else{
					offset = skok2-poz;
				}
				
				
				if(offset ==0) {
					bb.position(poz);
					for(int k=0; k < size;k++){
						bb.put((byte)0x02);
					}	
				}
				else{
					
					System.out.println("off " +offset);
					bb.position(poz+4);
					byte t = bb.get();
					bb.position(poz+1);
					bb.putInt(offset);
					bb.position(poz+4);
					bb.put(t);
					
					
					
				}
			}

		
		}
		
		
	}
	
	
}


public boolean checkJump(int poz, int skok){
	for (int i =0; i < jumps.size();i++){
		if(jumps.get(i)>poz && jumps.get(i) < skok )return false;
	}
	
	return true;
	
}



public void nop(int s, int e){
	int pos = bbuf.position();
	bbuf.position(s);
	for (int i=0; i <= e-s;i++){
		bbuf.put((byte) 0x02);
	}
	bbuf.position(pos);
}

public void zapiszSWF(String sciezka, int length){
	File file = new File(sciezka);
	FileOutputStream f;
	DataOutputStream out;
	byte b[] = new byte[length];
	System.arraycopy(bb.array(), 0, b, 0, length);
	try {
		f = new FileOutputStream(file);
		out = new DataOutputStream(f);
		out.write(b);
		out.close();
	
	}catch (Exception e) {
		e.printStackTrace();
	}
}


public static int unsignedInt(int b) {
    return  b & 0xFFFFFFFF;
 }

 public static int unsignedByte(byte b) {
	    return (int) b & 0xFF;
	    }

public static int unsignedShort(short b) {
	    return (int) b & 0xFFFF;
	    }


public static int unsigned30int(ByteBuffer bbuf){
	int  result = unsignedByte(bbuf.get());

if (!( (result & 0x00000080)>0))
		return result;
result = result & 0x0000007f | unsignedByte(bbuf.get())<<7;
if (!( (result & 0x00004000)>0))
	return result;
result = result & 0x00003fff | unsignedByte(bbuf.get())<<14;
if (!(  (result & 0x00200000)>0   ))
	return result;
result = result & 0x001fffff | unsignedByte(bbuf.get())<<21;
if (!(   (result & 0x10000000)>0   ))
	return result;
return   result & 0x0fffffff | unsignedByte(bbuf.get())<<28;

}

public static int  readS24(ByteBuffer bbuf)
{
	int b = unsignedByte(bbuf.get());
	b |= unsignedByte(bbuf.get())<<8;
	b |= bbuf.get()<<16;
	return b;
}




public static int signed32int(ByteBuffer bbuf){
	
	int  result = bbuf.get();

	if (!( (result & 0x00000080)>0)){
			return result;
	}
	result = result & 0x0000007f | bbuf.get()<<7;
	
	if (!( (result & 0x00004000)>0)){
		return result;
	}
	result = result & 0x00003fff | bbuf.get()<<14;

	if (!(  (result & 0x00200000)>0   )){
		return result;
	}
	result = result & 0x001fffff | bbuf.get()<<21;
	
	
	if (!(   (result & 0x10000000)>0   )){
		return result;
	}
	
	return   result & 0x0fffffff | bbuf.get()<<28;
	
}



public static int unsigned32int(ByteBuffer bbuf){
	
	int  result = unsignedByte(bbuf.get());
	
	if (!( (result & 0x00000080)>0))
			return result;
	result = result & 0x0000007f | unsignedByte(bbuf.get())<<7;
	if (!( (result & 0x00004000)>0))
		return result;
	result = result & 0x00003fff | unsignedByte(bbuf.get())<<14;
	if (!(  (result & 0x00200000)>0   ))
		return result;
	result = result & 0x001fffff | unsignedByte(bbuf.get())<<21;
	if (!(   (result & 0x10000000)>0   ))
		return result;
	return   result & 0x0fffffff | unsignedByte(bbuf.get())<<28;
	
}

//Zaporzyczone z projektu Tamarin abcdump
public static int readUBits(int numBits, ByteBuffer bbuf)
{
    if (numBits == 0)
    	return 0;

    int bitsLeft = numBits;
    int result = 0;

  
    int bitBuf = unsignedByte(bbuf.get());
    int bitPos = 8;
    

    while (true)
    {
        int shift = bitsLeft - bitPos;
        if (shift > 0)
        {
            // Consume the entire buffer
            result |= bitBuf << shift;
            bitsLeft -= bitPos;

            // Get the next byte from the input stream
            bitBuf = unsignedByte(bbuf.get());
            bitPos = 8;
        }
        else
        {
            // Consume a portion of the buffer
            result |= bitBuf >> -shift;
            bitPos -= bitsLeft;
            bitBuf &= 0xff >> (8 - bitPos); // mask off the consumed bits

//            if (print) //////// ("  read"+numBits+" " + result);
            return result;
        }
    }
}


public static ArrayList<Byte> getUI32(int i){
	ArrayList<Byte> al = new ArrayList<Byte>();
	
	if ( i <= 0x7F ){
		al.add((byte) i);
		return al;
		
	}else if ( i <= 0x3FFF && i>= 0x80 ){
		int i1 =  ((i & 0x7F) | 0x80);
		int i2=  ((i >> 7));
		al.add((byte) i1);
		al.add((byte) i2);
		
		return al;
		
	}else if ( i <= 0x1FFFFF  && i>=0x4000   ){
		int i1 = (((i & 0x7F) | 0x80));
		int i2 = (((i >> 7) | 0x80));
		int i3 = ((i>> 14));
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		return al;
		
	}else if ( i <= 0xFFFFFFF   && i>=0x200000    ){
		int i1 = (((i & 0x7F) | 0x80));
		int i2 =  (((i >> 7) | 0x80));
		int i3 =  (((i >> 14) | 0x80));
		int i4=  ((i>> 21));
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		al.add((byte) i4);
		return al;
		
		
	}else if (i>= 0x10000000    ){
		int i1 =  (((i & 0x7F) | 0x80));
		int i2 =  (((i >> 7) | 0x80));
		int i3 =  (((i >> 14) | 0x80));
		int i4 = (((i >> 21) | 0x80));
		int i5 =  ((i>> 28));
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		al.add((byte) i4);
		al.add((byte) i5);
		return al;
	}else return al;
	
	
}

public static ArrayList<Byte> getSI32(int i){
	int tmp = i;
	if (i<0) i *=-1;
	
	ArrayList<Byte> al = new ArrayList<Byte>();
	
	if ( i <= 0x7F ){
		if (tmp<0){
			int i1 =(~i+1)| 0x80;
			al.add((byte) i1);
			al.add((byte) 0xFF);
			al.add((byte) 0xFF);
			al.add((byte) 0xFF);
			al.add((byte) 0x0F);
			return al;
		}
		al.add((byte) i);
		return al;
		
		
		
	}else if ( i <= 0x3FFF && i>= 0x80 ){
		int i1 =  ((i & 0x7F) | 0x80);
		int i2=  ((i >> 7));
		if (tmp<0){
			i1= (~i1+1)| 0x80;
			i2=~(i2);
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) 0xFF);
			al.add((byte) 0xFF);
			al.add((byte) 0x0F);
			
			return al;
		}
		
		al.add((byte) i1);
		al.add((byte) i2);
		return al;
		
	}else if ( i <= 0x1FFFFF  && i>=0x4000   ){
		int i1 = (((i & 0x7F) | 0x80));
		int i2 = (((i >> 7) | 0x80));
		int i3 = ((i>> 14));
		if (tmp<0){
			i1= (~i1+1)| 0x80;
			i2=(~i2| 0x80);
			i3=~(i3);
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) 0xFF);
			al.add((byte) 0x0F);
			return al;
			
		}
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		return al;
		
	}else if ( i <= 0xFFFFFFF   && i>=0x200000    ){
		int i1 = (((i & 0x7F) | 0x80));
		int i2 =  (((i >> 7) | 0x80));
		int i3 =  (((i >> 14) | 0x80));
		int i4=  ((i>> 21));
		if (tmp<0){
			i1= (~i1+1)| 0x80;
			i2=(~i2| 0x80);
			i3=(~i3| 0x80);
			i4=~(i4);
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			al.add((byte) 0x0F);
			
			return al;
		}
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		al.add((byte) i4);
		
		return al;
		
		
	}else if (i>= 0x10000000    ){
		int i1 =  (((i & 0x7F) | 0x80));
		int i2 =  (((i >> 7) | 0x80));
		int i3 =  (((i >> 14) | 0x80));
		int i4 = (((i >> 21) | 0x80));
		int i5 =  ((i>> 28));
		if (tmp<0){
			i1= (~i1+1)| 0x80;
			i2=(~i2| 0x80);
			i3=(~i3| 0x80);
			i4=(~i4| 0x80);
			i5=~(i5);
			al.add((byte) i1);
			al.add((byte) i2);
			al.add((byte) i3);
			al.add((byte) i4);
			al.add((byte) i5);
			return al;
		}
		al.add((byte) i1);
		al.add((byte) i2);
		al.add((byte) i3);
		al.add((byte) i4);
		al.add((byte) i5);
		return al;
	}else return al;
	
	
}



}


